import { useRouter } from "@tanstack/react-router";
import { Button } from "./form/button";
import { Icons } from "./icons";
import { cn } from "@/lib/utils";
import { ComponentClassName } from "@/types/utility";

export function GoBack({
    className,
    children = <Icons.actions.back className="w-5 h-5 text-foreground" />,
}: ComponentClassName) {
    const { history } = useRouter();

    return (
        <Button
            variant={"ghost"}
            size={"icon"}
            className={cn(
                className
            )}
            onClick={() => {
                history.back()
            }}
        >
            {children}
            <span className="sr-only">Close planner</span>
        </Button>
    )
}